/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.SpecialCharacterDisplayElement;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.MessageLineInterface;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFParameterItem;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class MessageLineRTF
implements MessageLineInterface,
Serializable {
    private static final long serialVersionUID = -3465098652647564803L;
    private int serializedDataVersion = 1;
    private int fLineNumber;
    protected MessageParameter fMessageParameter;
    private boolean fTickerFlag;
    protected int fCharacterSet;
    protected int[] fContents = new int[32];
    final int SOFTKEY_OPC = 55;
    protected HashMap fBarInfo = new HashMap();
    protected HashMap fIONameInfo = new HashMap();
    private final int startProgramCount = 10;
    public static int TIME_DATA_DETAIL_ENTIME = 5;
    public static int TIME_DATA_DETAIL_ENDATE = 6;
    public static int TIME_DATA_DETAIL_TIME = 3;
    public static int TIME_DATA_DETAIL_DATE = 4;
    public static int SCALE_TIME_ID = 24;
    public static int ANALOG_INPUT_ID = 23;
    public static int TIME_DATE_ID = 22;
    public static int PARAMETER_ID = 21;
    public static int STATUS_NAME_IO_ID = 20;
    public static int SPECIAL_CHAR = 19;
    public static int BAR_ID = 18;

    public MessageLineRTF() {
    }

    public MessageLineRTF(MessageParameter msgParameter, int newLineNumber, int charSet) {
        this();
        this.fMessageParameter = msgParameter;
        this.fCharacterSet = charSet;
        this.initContents();
        this.setLineNumber(newLineNumber);
    }

    public MessageLineRTF(MessageParameter msgParameter) {
        this();
        this.fMessageParameter = msgParameter;
    }

    protected void initContents() {
        int i;
        for (i = 0; i < this.getLineWidth(); ++i) {
            this.fContents[i] = 32;
        }
        for (i = this.getLineWidth(); i < this.fContents.length; ++i) {
            this.fContents[i] = 0;
        }
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public void setLineNumber(int newLineNumber) {
        this.fLineNumber = newLineNumber;
    }

    public int[] getContentsBytes() {
        return this.fContents;
    }

    public HashMap getBarGraphMap() {
        return this.fBarInfo;
    }

    public HashMap getIONameMap() {
        return this.fIONameInfo;
    }

    private int[] getBarBytes(int barID) {
        if (!this.getBarGraphMap().containsKey(barID)) {
            int[] value = new int[8];
            this.getBarGraphMap().put(new Integer(barID), value);
        }
        return (int[])this.getBarGraphMap().get(barID);
    }

    private int[] getIONameBytes(int nameID) {
        if (!this.getIONameMap().containsKey(nameID)) {
            int[] value = new int[16];
            this.getIONameMap().put(new Integer(nameID), value);
        }
        return (int[])this.getIONameMap().get(nameID);
    }

    public boolean isTickerLine() {
        return this.fTickerFlag;
    }

    public void setTickerLine(boolean ticker) {
        this.fTickerFlag = ticker;
    }

    public void copyFrom(MessageLineInterface sourceImp, boolean registerListeners) {
        MessageLineRTF source = (MessageLineRTF)sourceImp;
        this.getBarGraphMap().putAll(source.getBarGraphMap());
        this.getIONameMap().putAll(source.getIONameMap());
        System.arraycopy(source.getContentsBytes(), 0, this.getContentsBytes(), 0, this.getContentsBytes().length);
        this.fCharacterSet = source.fCharacterSet;
        this.setTickerLine(source.isTickerLine());
        this.setLineNumber(source.getLineNumber());
    }

    private void writeText(DefaultDisplayElement displayElement, int position) {
        if (displayElement instanceof SpecialCharacterDisplayElement) {
            if (displayElement.getWidth() == 1) {
                int charValue = ((SpecialCharacterDisplayElement)displayElement).getCharCode();
                this.setSpecialChar(position, true);
                this.getContentsBytes()[position] = charValue & 0xFF;
            } else {
                int charValue = ((SpecialCharacterDisplayElement)displayElement).getCharCode();
                this.getContentsBytes()[position] = SPECIAL_CHAR;
                this.getContentsBytes()[position + 1] = charValue;
            }
        } else {
            String text;
            byte[] arr;
            if (displayElement.getWidth() == 1) {
                this.setSpecialChar(position, false);
            }
            if ((arr = MessageGlobalInfo.getCharsetEncoding(this.fCharacterSet, (text = displayElement.getUserObject().toString()).charAt(0))) != null) {
                for (int i = 0; i < displayElement.getWidth(); ++i) {
                    this.getContentsBytes()[position + i] = arr[i] & 0xFF;
                }
            } else {
                System.err.println("error, text info missing.");
            }
        }
    }

    private void writeBar(BarDisplayElement displayElement, int position) {
        this.getContentsBytes()[position + 0] = BAR_ID;
        this.getContentsBytes()[position + 1] = displayElement.getID();
        int[] bytes = this.getBarBytes(displayElement.getID());
        bytes[0] = (displayElement.getDirection() << 7) + displayElement.getLength() & 0xFF;
        ParameterItem refParamItem = displayElement.getParameterItem();
        Block block = refParamItem.getParameter().getBlock();
        UDFBlock udf = null;
        if (block instanceof UDFBlock) {
            udf = (UDFBlock)block;
            ParameterItem item = ((UDFParameterItem)displayElement.getParameterItem()).getRootSourceParameterItem();
            block = item.getParameter().getBlock();
        }
        bytes[1] = block.getNumber() - 1 + 10 & 0xFF;
        bytes[2] = udf != null ? (int)((byte)udf.getOpcode()) : block.getOpcode();
        bytes[3] = refParamItem.getParameterNumber() | block.getNumber() - 1 + 10 >> 2 & 0xC0;
        bytes[4] = displayElement.getMinValue() & 0xFF;
        bytes[5] = (displayElement.getMinValue() & 0xFF00) >> 8;
        bytes[6] = displayElement.getMaxValue() & 0xFF;
        bytes[7] = (displayElement.getMaxValue() & 0xFF00) >> 8;
    }

    private void writeAI(AIDisplayElement displayElement, int position) {
        this.getContentsBytes()[position + 0] = ANALOG_INPUT_ID;
        this.getContentsBytes()[position + 1] = 0;
        this.getContentsBytes()[position + 2] = 11;
        this.getContentsBytes()[position + 3] = displayElement.getAINumber() - 1;
    }

    private void writeIOName(IONameDisplayElement displayElement, int position) {
        this.getContentsBytes()[position + 0] = STATUS_NAME_IO_ID;
        this.getContentsBytes()[position + 1] = displayElement.getID();
        this.getContentsBytes()[position + 2] = displayElement.getType();
        this.getContentsBytes()[position + 3] = displayElement.getNumber() - 1 & 0xFF;
        this.getContentsBytes()[position + 4] = displayElement.getNumber() - 1 >> 8;
        this.getContentsBytes()[position + 5] = 0;
        this.getContentsBytes()[position + 6] = 0;
        this.getContentsBytes()[position + 7] = 0;
        int[] bytes = this.getIONameBytes(displayElement.getID());
        for (int i = 0; i < 2; ++i) {
            int j;
            int[] nameBytes = displayElement.getNameBytes(i);
            for (j = 0; j < nameBytes.length; ++j) {
                bytes[i * 8 + j] = nameBytes[j] + 256 & 0xFF;
            }
            for (j = nameBytes.length; j < 8; ++j) {
                bytes[i * 8 + j] = 0;
            }
        }
    }

    private void writeParameter(ParameterItem displayElement, int position) {
        String paraID = displayElement.getIdentifier();
        Block block = displayElement.getParameter().getBlock();
        UDFBlock udf = null;
        if (block instanceof UDFBlock) {
            udf = (UDFBlock)block;
            displayElement = ((UDFParameterItem)displayElement).getRootSourceParameterItem();
            block = displayElement.getParameter().getBlock();
        }
        if (paraID.equals("Time")) {
            this.getContentsBytes()[position + 0] = TIME_DATE_ID;
            this.getContentsBytes()[position + 1] = TIME_DATA_DETAIL_TIME;
        } else if (paraID.equals("Date")) {
            this.getContentsBytes()[position + 0] = TIME_DATE_ID;
            this.getContentsBytes()[position + 1] = TIME_DATA_DETAIL_DATE;
        } else if (paraID.equals("EnableTime")) {
            this.getContentsBytes()[position + 0] = TIME_DATE_ID;
            this.getContentsBytes()[position + 1] = TIME_DATA_DETAIL_ENTIME;
        } else if (paraID.equals("EnableDate")) {
            this.getContentsBytes()[position + 0] = TIME_DATE_ID;
            this.getContentsBytes()[position + 1] = TIME_DATA_DETAIL_ENDATE;
        } else {
            this.getContentsBytes()[position + 0] = PARAMETER_ID;
            this.getContentsBytes()[position + 1] = block.getNumber() - 1 + 10 & 0xFF;
            this.getContentsBytes()[position + 2] = udf != null ? (int)((byte)udf.getOpcode()) : (int)((byte)block.getOpcode(block.getHardware(), block.getNumber()));
            this.getContentsBytes()[position + 3] = block.getNumber() - 1 + 10 >> 2 & 0xC0;
            if (block.getOpcode(block.getHardware(), block.getNumber()) != 55) {
                int[] nArray = this.getContentsBytes();
                int n = position + 3;
                nArray[n] = nArray[n] | displayElement.getParameterNumber();
            }
        }
    }

    public void writeScaleTime(ScaleTimeDisplayElement displayElement, int position) {
        this.getContentsBytes()[position + 0] = SCALE_TIME_ID;
        this.getContentsBytes()[position + 1] = displayElement.getTimeBase();
        Block block = displayElement.getParameterItem().getParameter().getBlock();
        UDFBlock udf = null;
        if (block instanceof UDFBlock) {
            udf = (UDFBlock)block;
            ParameterItem item = ((UDFParameterItem)displayElement.getParameterItem()).getRootSourceParameterItem();
            block = item.getParameter().getBlock();
        }
        int blockNumber = block.getNumber() - 1 + 10;
        this.getContentsBytes()[position + 2] = Util.getLowByte(blockNumber);
        this.getContentsBytes()[position + 3] = Util.getHighByte(blockNumber);
        this.getContentsBytes()[position + 4] = displayElement.getParameterItem().getParameterNumber();
        this.getContentsBytes()[position + 5] = udf != null ? (int)((byte)udf.getOpcode()) : (int)((byte)block.getOpcode(block.getHardware(), block.getNumber()));
    }

    public void setDisplayElement(DisplayElement displayElement, int position) {
        if (displayElement instanceof ParameterItem) {
            this.writeParameter((ParameterItem)displayElement, position);
        } else if (displayElement instanceof BarDisplayElement) {
            this.writeBar((BarDisplayElement)displayElement, position);
        } else if (displayElement instanceof AIDisplayElement) {
            this.writeAI((AIDisplayElement)displayElement, position);
        } else if (displayElement instanceof DefaultDisplayElement) {
            this.writeText((DefaultDisplayElement)displayElement, position);
        } else if (displayElement instanceof IONameDisplayElement) {
            this.writeIOName((IONameDisplayElement)displayElement, position);
        } else if (displayElement instanceof ScaleTimeDisplayElement) {
            this.writeScaleTime((ScaleTimeDisplayElement)displayElement, position);
        } else if (displayElement == null) {
            this.getContentsBytes()[position] = 0;
        }
    }

    private DisplayElement getAIDisplayElement(int pos) {
        int AINumber = this.getContentsBytes()[pos + 3] + 1;
        AIDisplayElement ret = new AIDisplayElement(this.fMessageParameter.getBlock().getWiringDiagram(), AINumber);
        if (ret.getBlock() == null) {
            ret = null;
        }
        return ret;
    }

    private DisplayElement getIOnameDisplayElement(int pos) {
        int nameID = this.getContentsBytes()[pos + 1];
        int type = this.getContentsBytes()[pos + 2];
        int blockNumber = (this.getContentsBytes()[pos + 4] << 8 | this.getContentsBytes()[pos + 3]) + 1;
        IONameDisplayElement ret = new IONameDisplayElement(this.fMessageParameter.getBlock().getWiringDiagram(), nameID, type, blockNumber);
        ret.setCharSet(this.fCharacterSet);
        int[] bytes = this.getIONameBytes(nameID);
        for (int i = 0; i < 2; ++i) {
            int[] nameBytes = new int[8];
            System.arraycopy(bytes, i * 8, nameBytes, 0, 8);
            ret.setNameByte(i, nameBytes);
        }
        if (ret.getBlock() == null) {
            ret = null;
        }
        return ret;
    }

    private DisplayElement getBarDisplayElement(int pos) {
        ParameterItem paramItem;
        int barID = this.getContentsBytes()[pos + 1];
        int[] bytes = this.getBarBytes(barID);
        int direction = bytes[0] >> 7;
        int length = bytes[0] & 0x7F;
        int blockNumber = this.getBlockNumberFromProgramLine((bytes[3] & 0xC0) << 2 | bytes[1]);
        int opcode = bytes[2];
        int paramNumber = bytes[3] & 0x3F;
        boolean isUDF = false;
        if (opcode == 153) {
            isUDF = true;
            WiringDiagram wd = this.fMessageParameter.getBlock().getWiringDiagram();
            Block rootBlock = wd.getExpansionBlockByNumber(0, blockNumber);
            if (rootBlock == null) {
                return null;
            }
        }
        if ((paramItem = this.getParameterItem(isUDF, blockNumber, paramNumber)) == null) {
            return null;
        }
        int min = Util.makeSignedWord(bytes[5], bytes[4]);
        int max = Util.makeSignedWord(bytes[7], bytes[6]);
        BarDisplayElement ret = new BarDisplayElement(barID, paramItem, direction, length, max, min);
        return ret;
    }

    private DisplayElement getDateTimeItem(int index) {
        ParameterItem ret = null;
        String paraID = null;
        int detail = this.getContentsBytes()[index + 1];
        if (detail == TIME_DATA_DETAIL_TIME) {
            paraID = "Time";
        } else if (detail == TIME_DATA_DETAIL_DATE) {
            paraID = "Date";
        } else if (detail == TIME_DATA_DETAIL_ENTIME) {
            paraID = "EnableTime";
        } else if (detail == TIME_DATA_DETAIL_ENDATE) {
            paraID = "EnableDate";
        }
        ret = this.fMessageParameter.getParameterItem(paraID);
        return ret;
    }

    private DisplayElement getParameterItem(int index) {
        ParameterItem ret = null;
        boolean isUDF = false;
        int blockNumber = this.getBlockNumberFromProgramLine((this.getContentsBytes()[index + 3] & 0xC0) << 2 | this.getContentsBytes()[index + 1]);
        int opcode = this.getContentsBytes()[index + 2] & 0xFF;
        int paramNumber = 0;
        WiringDiagram wd = this.fMessageParameter.getBlock().getWiringDiagram();
        if (opcode == 153) {
            isUDF = true;
            Block rootBlock = wd.getExpansionBlockByNumber(0, blockNumber);
            if (rootBlock == null) {
                return null;
            }
            opcode = rootBlock.getOpcode();
        }
        if (opcode != 55) {
            paramNumber = this.getContentsBytes()[index + 3] & 0x3F;
        }
        try {
            ret = this.getParameterItem(isUDF, blockNumber, paramNumber);
        }
        catch (Exception e) {
            return new DefaultDisplayElement("?", 1, 1);
        }
        return ret;
    }

    private DisplayElement getScaleTimeDisplayElement(int index) {
        int timebase = this.getContentsBytes()[index + 1];
        int progLineNr = Util.makeWord(this.getContentsBytes()[index + 2], this.getContentsBytes()[index + 3]);
        int blockNumber = this.getBlockNumberFromProgramLine(progLineNr);
        int paramNumber = this.getContentsBytes()[index + 4];
        boolean isUDF = false;
        if ((this.getContentsBytes()[index + 5] & 0xFF) == 153) {
            isUDF = true;
            WiringDiagram wd = this.fMessageParameter.getBlock().getWiringDiagram();
            Block rootBlock = wd.getExpansionBlockByNumber(0, blockNumber);
            if (rootBlock == null) {
                return null;
            }
        }
        ScaleTimeDisplayElement ret = new ScaleTimeDisplayElement();
        ret.setTimeBase(timebase);
        ParameterItem paramItem = this.getParameterItem(isUDF, blockNumber, paramNumber);
        if (paramItem == null) {
            return null;
        }
        ret.setParameterItem(paramItem);
        return ret;
    }

    private int getBlockNumberFromProgramLine(int programline) {
        int startProgramCount = 10;
        return programline - 10 + 1;
    }

    @Deprecated
    private ParameterItem getParameterItem(int opcode, int blockNumber, int index) {
        WiringDiagram wd = this.fMessageParameter.getBlock().getWiringDiagram();
        return wd.getParameterItemByOpcode(opcode, blockNumber, index);
    }

    private ParameterItem getParameterItem(boolean isUDF, int rootBlockNumber, int rootParameterNumber) {
        WiringDiagram wd = this.fMessageParameter.getBlock().getWiringDiagram();
        Block rootBlock = wd.getExpansionBlockByNumber(0, rootBlockNumber);
        if (rootBlock == null) {
            return null;
        }
        BlockParameter rootParameter = rootBlock.getParameter();
        if (isUDF) {
            UDFBlock udfBlock = (UDFBlock)wd.getOutestBlock(rootBlock);
            return udfBlock.getUDFParaItemByRootParaItem(rootParameter, rootParameterNumber);
        }
        ParameterItem paraItem = rootParameter.getParameterItems().getParameterItem(rootParameterNumber);
        return paraItem.getInstanceForParameter(rootParameter);
    }

    public boolean hardwareChangeFinished(HardwareChangedEvent hardwareChangedEvent) {
        WiringDiagram wd = this.fMessageParameter.getBlock().getWiringDiagram();
        int x = 0;
        while (x < this.getLineWidth()) {
            int curID;
            DisplayElement disp = this.getDisplayElement(x);
            if (disp instanceof IONameDisplayElement && (curID = ((IONameDisplayElement)disp).getID()) >= wd.getHardware().getIntProperty("RTFMaxIOStatusItemTotal")) {
                int newID;
                this.getContentsBytes()[x + 1] = newID = wd.getMessageManager().getFreeID(STATUS_NAME_IO_ID, null, new Vector());
                this.getIONameMap().put(newID, this.getIONameMap().get(curID));
                this.getIONameMap().remove(curID);
            }
            if (disp != null) {
                x += disp.getWidth();
                continue;
            }
            ++x;
        }
        return true;
    }

    public DisplayElement getDisplayElement(int pos) {
        DisplayElement displayElement = null;
        int cur = this.getContentsBytes()[pos];
        if (cur == 0) {
            return null;
        }
        displayElement = cur == BAR_ID ? this.getBarDisplayElement(pos) : (cur == STATUS_NAME_IO_ID ? this.getIOnameDisplayElement(pos) : (cur == PARAMETER_ID ? this.getParameterItem(pos) : (cur == TIME_DATE_ID ? this.getDateTimeItem(pos) : (cur == ANALOG_INPUT_ID ? this.getAIDisplayElement(pos) : (cur == SCALE_TIME_ID ? this.getScaleTimeDisplayElement(pos) : this.getTextDisplayElement(this.getContentsBytes(), pos))))));
        return displayElement;
    }

    private DisplayElement getTextDisplayElement(int[] bytes, int index) {
        DisplayElement ret;
        int curByte = bytes[index];
        if (this.isBiWidthCharacterset()) {
            int nextByte = -1;
            if (index + 1 < this.getLineWidth()) {
                nextByte = bytes[index + 1];
            }
            if (curByte == SPECIAL_CHAR) {
                if (nextByte == -1) {
                    ret = new DefaultDisplayElement(" ", 1, 1);
                } else {
                    ret = MessageLine.getSpecialCharacterDisplayElement((char)nextByte);
                    if (ret instanceof SpecialCharacterDisplayElement) {
                        ((SpecialCharacterDisplayElement)ret).setWidth(2);
                    }
                }
            } else {
                ret = curByte <= 127 ? new DefaultDisplayElement(MessageLineRTF.getOneByteString(curByte, this.fCharacterSet), 1, 1) : (nextByte == -1 ? new DefaultDisplayElement("?", 1, 1) : new DefaultDisplayElement(MessageLineRTF.getTwoBytesString(curByte, nextByte, this.fCharacterSet), 2, 1));
            }
        } else {
            ret = this.isSpecialChar(index) ? MessageLine.getSpecialCharacterDisplayElement((char)curByte) : new DefaultDisplayElement(MessageLineRTF.getOneByteString(curByte, this.fCharacterSet), 1, 1);
        }
        return ret;
    }

    public static String getOneByteString(int curByte, int charSet) {
        String ret = null;
        if (curByte == 0) {
            ret = " ";
        } else if (curByte < 32 || curByte > 127 && curByte <= 159) {
            ret = "?";
        } else if (curByte <= 127) {
            ret = Character.toString((char)curByte);
        } else if (MessageGlobalInfo.isBiWidthCharSet(charSet)) {
            System.err.println("Bad byte: " + curByte);
            ret = "?";
        } else {
            ret = String.valueOf(MessageGlobalInfo.getUnicodeChar(charSet, new byte[]{(byte)curByte}));
        }
        return ret;
    }

    public static String getTwoBytesString(int byte0, int byte1, int charSet) {
        String ret = String.valueOf(MessageGlobalInfo.getUnicodeChar(charSet, new byte[]{(byte)byte0, (byte)byte1}));
        if (ret.equals("?")) {
            return new String("??");
        }
        return ret;
    }

    public boolean isBiWidthCharacterset() {
        return MessageGlobalInfo.isBiWidthCharSet(this.fCharacterSet);
    }

    private boolean isSpecialChar(int pos) {
        if (this.isBiWidthCharacterset()) {
            return false;
        }
        int byteIndex = pos / 8;
        int bitIndex = 8 - pos % 8 - 1;
        int flagByte = this.getContentsBytes()[this.getLineWidth() + byteIndex];
        return (flagByte & 1 << bitIndex) > 0;
    }

    private void setSpecialChar(int pos, boolean flag) {
        if (this.isBiWidthCharacterset()) {
            return;
        }
        int byteIndex = pos / 8;
        int bitIndex = 8 - pos % 8 - 1;
        int flagByte = this.getContentsBytes()[this.getLineWidth() + byteIndex];
        int mask = 1 << bitIndex;
        flagByte &= ~mask;
        this.getContentsBytes()[this.getLineWidth() + byteIndex] = flagByte |= (flag ? 1 : 0) << bitIndex;
    }

    public int getLineWidth() {
        if (this.isBiWidthCharacterset()) {
            return 32;
        }
        return 24;
    }

    public boolean messageLineCleared() {
        if (!this.isCompilerActive()) {
            return false;
        }
        boolean ret = false;
        int i = 0;
        while (i < this.getLineWidth()) {
            DisplayElement displayElement = this.getDisplayElement(i);
            if (displayElement == null) {
                int j;
                if (this.getContentsBytes()[i] == PARAMETER_ID) {
                    for (j = 0; j < 4; ++j) {
                        this.getContentsBytes()[i + j] = 0;
                    }
                    ret = true;
                    i += 4;
                    continue;
                }
                if (this.getContentsBytes()[i] == BAR_ID) {
                    this.deleteBarInMap(this.getContentsBytes()[i + 1]);
                    for (j = 0; j < 2; ++j) {
                        this.getContentsBytes()[i + j] = 0;
                    }
                    ret = true;
                    i += 2;
                    continue;
                }
                if (this.getContentsBytes()[i] == ANALOG_INPUT_ID) {
                    for (j = 0; j < 4; ++j) {
                        this.getContentsBytes()[i + j] = 0;
                    }
                    ret = true;
                    i += 4;
                    continue;
                }
                if (this.getContentsBytes()[i] == STATUS_NAME_IO_ID) {
                    this.deleteIONameInMap(this.getContentsBytes()[i + 1]);
                    for (j = 0; j < 8; ++j) {
                        this.getContentsBytes()[i + j] = 0;
                    }
                    ret = true;
                    i += 8;
                    continue;
                }
                if (this.getContentsBytes()[i] == SCALE_TIME_ID) {
                    for (j = 0; j < 6; ++j) {
                        this.getContentsBytes()[i + j] = 0;
                    }
                    ret = true;
                    i += 6;
                    continue;
                }
                ++i;
                continue;
            }
            i += displayElement.getWidth();
        }
        return ret;
    }

    private boolean isCompilerActive() {
        WiringDiagram wd = this.fMessageParameter.getBlock().getWiringDiagram();
        if (wd instanceof WiringDiagramKop) {
            return ((WiringDiagramKop)wd).getFupCompiler().isCompilerActivated();
        }
        return true;
    }

    private void deleteBarInMap(int barID) {
        this.getBarGraphMap().remove(barID);
    }

    private void deleteIONameInMap(int nameID) {
        this.getIONameMap().remove(nameID);
    }

    public void clearMapInfo() {
        int i = 0;
        while (i < this.getLineWidth()) {
            if (this.getContentsBytes()[i] == BAR_ID) {
                int barID = this.getContentsBytes()[i + 1];
                this.deleteBarInMap(barID);
                i += 2;
                continue;
            }
            if (this.getContentsBytes()[i] == STATUS_NAME_IO_ID) {
                int nameID = this.getContentsBytes()[i + 1];
                this.deleteIONameInMap(nameID);
                i += 8;
                continue;
            }
            ++i;
        }
        if (this.getIONameMap().size() != 0 || this.getBarGraphMap().size() != 0) {
            System.out.println("Error in bar and ioName info sync.");
        }
    }

    public String getStringInfo(boolean areAllElements) {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < this.getLineWidth()) {
            DisplayElement disp = this.getDisplayElement(i);
            if (disp != null) {
                if (disp instanceof DefaultDisplayElement) {
                    ret.append(disp.getContentsString());
                } else if (areAllElements) {
                    ret.append("(");
                    ret.append(disp.getContentsString());
                    ret.append(")");
                } else {
                    for (int k = 0; k < disp.getWidth(); ++k) {
                        ret.append(" ");
                    }
                }
                i += disp.getWidth();
                continue;
            }
            ret.append(" ");
            ++i;
        }
        while (ret.length() > 0 && ret.charAt(ret.length() - 1) == ' ') {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    public int getCharacterSet() {
        return this.fCharacterSet;
    }
}

